USE [Elerium]
GO

/****** Object:  StoredProcedure [dbo].[RP_AwardDailyPointsToUsers]    Script Date: 10/21/2013 9:19:18 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





-- =============================================
-- Author:		<James Davis>
-- Create date: <2013-07-31>
-- Description:	<This will divide up the daily points we have and award them to the users, 
--				it will also record how many points each project got 
--				and for the User what projects contributed how many point to the total it got for that day. >
-- =============================================
ALTER PROCEDURE [dbo].[RP_AwardDailyPointsToUsers]
	@errorMessage varchar(2048) OUTPUT 
AS
DECLARE @dailyBudgetDate date, @addonPoints money, @libraryPoints money, @bonusPoints money, @dailyPoints money, 
		@popularityThreshold int, @dailyBudgetId int, @returnCode int = 1, @fairness decimal(3,2),
		@totalOfLibsAdjPopScores money, @totalOfAddonAdjPopScores money, @cursorUserID int, @cursorPoints money, @cursorProjectID int, @cursorNewId int,
		@totalPointsGiven money, @codeReturned int
BEGIN
	-- SET XACT_ABORT ON will cause the transaction to be uncommittable when the constraint violation occurs. 
	SET XACT_ABORT ON;
	SET NOCOUNT ON;
	SELECT @errorMessage = 'completed sucessfully';

	SELECT @dailyBudgetDate = GETUTCDATE();

	-- check if daily budget exists for today, if not create it, cannot run this sproc with out the days budget
	IF (SELECT ID FROM [dbo].[RewardDailyBudget] WHERE DailyBudgetDate = @dailyBudgetDate) IS NULL
		BEGIN
			EXEC @codeReturned = [dbo].RP_GenerateDailyBudget;
			IF (@codeReturned <> 1)
				BEGIN
					SELECT @errorMessage = ERROR_MESSAGE();
					RETURN(@codeReturned);
				END;
		END;

	SELECT @dailyBudgetID = (SELECT ID FROM [dbo].[RewardDailyBudget] WHERE DailyBudgetDate = @dailyBudgetDate);

	-- check to see if this sproc has run already, if so return good
	IF (SELECT top 1 ID FROM [dbo].[RewardProjectReward] WHERE DailyBudgetID = @dailyBudgetID) IS NOT NULL
		RETURN;

	-- check to see if LibraryEligibility and UserEligibilty sprocs ran
	IF (SELECT top 1 ID FROM [dbo].[RewardSplit] WHERE DailyBudgetDate = @dailyBudgetDate) IS NULL
		BEGIN
			EXEC @codeReturned = [dbo].RP_UserEligibility;
			IF (@codeReturned <> 1)
				BEGIN
					SELECT @errorMessage = ERROR_MESSAGE();
					RETURN(@codeReturned);
				END;
		END;

	IF (SELECT TOP 1 ID FROM [dbo].[RewardSplit] WHERE DailyBudgetDate = @dailyBudgetDate AND Islibrary = 1) IS NULL
		BEGIN
			EXEC @codeReturned = [dbo].RP_LibraryEligibility;
			IF (@codeReturned <> 1)
				BEGIN
					SELECT @errorMessage = ERROR_MESSAGE();
					RETURN(@codeReturned);
				END;
		END;

	SELECT @dailyPoints = (SELECT DailyPoints FROM [dbo].[RewardDailyBudget] WHERE DailyBudgetDate = @dailyBudgetDate);
	SELECT @addonPoints = ROUND((SELECT AddonPercentage * DailyPoints FROM [dbo].[RewardDailyBudget] WHERE DailyBudgetDate = @dailyBudgetDate),4,1);
	SELECT @libraryPoints = ROUND((SELECT LibraryPercentage  * DailyPoints FROM [dbo].[RewardDailyBudget] WHERE DailyBudgetDate = @dailyBudgetDate),4,1);
	-- bouns points will be dailypoints minus ( sum(addonpoints given) plus sum(librarypoints given) )
	--SELECT @bonusPoints = ROUND((SELECT BonusPercentage  * DailyPoints FROM [dbo].[RewardDailyBudget] WHERE DailyBudgetDate = @dailyBudgetDate),4);
	SELECT @popularityThreshold = (SELECT PopularityThreshold FROM [dbo].[RewardDailyBudget] WHERE DailyBudgetDate = @dailyBudgetDate);
	SELECT @fairness = (SELECT [Fairness] FROM [dbo].[RewardDailyBudget] WHERE DailyBudgetDate = @dailyBudgetDate);
	

	SELECT @totalOfAddonAdjPopScores = (SELECT sum(POWER(rpp.PopularityScore, @fairness))
									FROM (select distinct ProjectID, LibraryPopularity from [dbo].[RewardSplit] where Islibrary = 0) AS rs
									left join [dbo].[RewardProject] rpp ON rs.ProjectID = rpp.ID
									WHERE rpp.PopularityScore >= @popularityThreshold  )

	SELECT @totalOfLibsAdjPopScores = (SELECT sum(POWER(rs.LibraryPopularity + rpp.PopularityScore, @fairness))
									FROM (select distinct ProjectID, LibraryPopularity from [dbo].[RewardSplit] where Islibrary = 1) AS rs
									left join [dbo].[RewardProject] rpp ON rs.ProjectID = rpp.ID
									WHERE rs.LibraryPopularity + rpp.PopularityScore >= @popularityThreshold  )

BEGIN TRY
	BEGIN TRANSACTION;
	BEGIN TRY
		BEGIN TRANSACTION;  --- put all update inserts between the TRANSACTION Begin and COMMIT with XACT_ABORT ON so If one fails they all do not commit
		-- Start building the entries for RewardProjectReward for the DailyBudget
		--do Libraries first
		INSERT INTO [dbo].[RewardProjectReward](RewardProjectID, DailyBudgetID, IsLibrary, RewardedPoints, PopularityScore, LibraryPopularity, AdjustedPopularityScore)
		SELECT distinct rs.ProjectID,
		@dailyBudgetID,
		rs.Islibrary,
		ROUND(@libraryPoints * ROUND((POWER(rs.LibraryPopularity + rpp.PopularityScore, @fairness)),4,1) / @totalOfLibsAdjPopScores,4,1),
		rpp.PopularityScore,
		rs.LibraryPopularity, 
		ROUND((POWER(rs.LibraryPopularity + rpp.PopularityScore, @fairness)),4,1) AS AdjustedPopScore
		FROM [dbo].[RewardSplit] AS rs
		left join [dbo].[RewardProject] rpp ON rs.ProjectID = rpp.ID
		WHERE rs.LibraryPopularity + rpp.PopularityScore >= @popularityThreshold 
		AND rs.Islibrary = 1
		order by rs.ProjectID;
		-- now regular addons
		INSERT INTO [dbo].[RewardProjectReward](RewardProjectID, DailyBudgetID, IsLibrary, RewardedPoints, PopularityScore, LibraryPopularity, AdjustedPopularityScore)
		SELECT distinct rs.ProjectID, 
		@dailyBudgetID,
		rs.Islibrary,
		ROUND(@addonPoints * ROUND((POWER(rpp.PopularityScore, @fairness)),4,1) / @totalOfAddonAdjPopScores,4,1),
		rpp.PopularityScore,
		rs.LibraryPopularity, 
		ROUND((POWER(rpp.PopularityScore, @fairness)),4,1) AS AdjustedPopScore
		FROM [dbo].[RewardSplit] AS rs
		left join [dbo].[RewardProject] rpp ON rs.ProjectID = rpp.ID
		WHERE rpp.PopularityScore >= @popularityThreshold 
		AND rs.Islibrary = 0
		order by rs.ProjectID;
	
		IF OBJECT_ID('tempdb..#tempTransBreak') IS NOT NULL
		DROP TABLE #tempTransBreak
		CREATE TABLE #tempTransBreak(projectID int, recordID int null, points money, userID int);
	
		INSERT INTO #tempTransBreak(projectID, userID, points)
		Select rpr.RewardProjectID, 
		rs.UserID, 
		rpr.RewardedPoints * rs.Percentage as Points
		FROM [dbo].[RewardProjectReward] rpr
		left join [dbo].[RewardSplit] rs ON rpr.RewardProjectID = rs.ProjectID
		WHERE rpr.DailyBudgetID = @dailyBudgetID
		order by rs.UserID
	
		-- 
		DECLARE transaction_cur CURSOR FOR
		SELECT userID, Sum(points) 
		FROM #tempTransBreak 
		GROUP BY userID 
		ORDER BY userID
		OPEN transaction_cur
		FETCH NEXT FROM transaction_cur
		INTO @cursorUserID, @cursorPoints
		WHILE @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO [dbo].[RewardTransaction] 
			(UserID
			,DateCreated
			,PointChange
			,[Type]
			,DailyBudgetID)
			VALUES
			(@cursorUserID
			,GETUTCDATE()
			,@cursorPoints
			,1
			,@dailyBudgetID)

			SELECT @cursorNewId = SCOPE_IDENTITY()

			UPDATE #tempTransBreak SET recordID = @cursorNewId WHERE userID = @cursorUserID

			INSERT INTO [dbo].[RewardTransactionBreakdown] 
			(ProjectID
			,RewardTransactionID
			,Points)
			SELECT projectID,recordID,points FROM #tempTransBreak WHERE userID = @cursorUserID

			FETCH NEXT FROM transaction_cur INTO @cursorUserID, @cursorPoints
		END
		CLOSE transaction_cur
		DEALLOCATE transaction_cur
	
		DROP TABLE #tempTransBreak;

		--UPDATE [dbo].[RewardsProgram] SET BonusPoints = (SELECT BonusPoints + @bonusPoints FROM [dbo].[RewardsProgram]);
	
		COMMIT TRANSACTION;
	END TRY
	BEGIN CATCH
		ROLLBACK TRANSACTION;
		SELECT @returnCode = 111;
		--PRINT ERROR_MESSAGE();
		SELECT @errorMessage = ERROR_MESSAGE();
		RETURN @returnCode;
	END CATCH;

	-- now do the bonus pool points
	BEGIN TRY
		BEGIN TRANSACTION
		SELECT @totalPointsGiven = (select sum(PointChange) FROM [dbo].[RewardTransaction] where DailyBudgetID = @dailyBudgetId)
		SELECT @bonusPoints = @dailyPoints - @totalPointsGiven
		UPDATE [dbo].[RewardsProgram] SET BonusPoints = (SELECT BonusPoints + @bonusPoints FROM [dbo].[RewardsProgram]);
		UPDATE [dbo].[RewardDailyBudget] SET ActualBonusPointsAdded = @bonusPoints WHERE ID = @dailyBudgetId;
		COMMIT TRANSACTION;
	END TRY
	BEGIN CATCH
		ROLLBACK TRANSACTION;
		SELECT @returnCode = 222;
		--PRINT ERROR_MESSAGE();
		SELECT @errorMessage = ERROR_MESSAGE();
		RETURN @returnCode;
	END CATCH;


COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	ROLLBACK TRANSACTION;
	SELECT @returnCode = 333;
	--PRINT ERROR_MESSAGE();
	SELECT @errorMessage = ERROR_MESSAGE();
	RETURN @returnCode
END CATCH;
	RETURN @returnCode    

END




GO


